<?php
/**
 * Created by PhpStorm.
 * User: gets
 * Date: 4/4/2019
 * Time: 3:24 PM
 */

namespace App\Http\Controllers;

use App\Classes\MResponse;
use App\Http\Request\MSAppCreateRequest;
use App\Http\Request\MSAppUpdateRequest;
use App\Http\Request\MSAppDeleteRequest;
use App\Http\Request\MSAppGetByAppIdRequest;
use App\Http\Request\MSAppGetByUserIdRequest;

class ApplicationController extends BaseController
{
    public function create(MSAppCreateRequest $request)
    {
        $mResponse = new MResponse();
        $statusCode = 200;
        
        $url = 'https://api.mashery.com/v3/rest/members/' . $request->get('userId') . '/applications'; 

        try {
            $response = $this->masheryClient()->request('POST', $url, [
                'json' => [
                    'name' => 'WebApp',
                    'username' => $request->get('username')
                ]
            ]);

            $resBody = json_decode($response->getBody()->getContents(), true);

            if ($response->getStatusCode() != 200) {
                $statusCode = $response->getStatusCode();
                $mResponse->message = $resBody;
            } else {
                $mResponse->success = true;
                $mResponse->message = 'success';
                $mResponse->data = $resBody;
            }
        } catch (\Exception $e) {
            $statusCode = 500;
            $mResponse->message = $e->getMessage();
        }

        return response()->json($mResponse, $statusCode);
    }

    public function update(MSAppUpdateRequest $request)
    {
        $mResponse = new MResponse();
        $statusCode = 200;
        
        $url = 'https://api.mashery.com/v3/rest/members/' . $request->get('userId') . '/applications/' . $request->get('appId'); 

        try {
            $response = $this->masheryClient()->request('PUT', $url, [
                'json' => [
                    'name' => 'UpdateApp',
                    'description' => 'Update'
                ]
            ]);

            $resBody = json_decode($response->getBody()->getContents(), true);

            if ($response->getStatusCode() != 200) {
                $statusCode = $response->getStatusCode();
                $mResponse->message = $resBody;
            } else {
                $mResponse->success = true;
                $mResponse->message = 'success';
                $mResponse->data = $resBody;
            }
        } catch (\Exception $e) {
            $statusCode = 500;
            $mResponse->message = $e->getMessage();
        }

        return response()->json($mResponse, $statusCode);
    }

    public function delete(MSAppDeleteRequest $request)
    {
        $mResponse = new MResponse();
        $statusCode = 200;
        
        $url = 'https://api.mashery.com/v3/rest/members/' . $request->get('userId') . '/applications/' . $request->get('appId'); 

        try {
            $response = $this->masheryClient()->request('DELETE', $url);

            $resBody = json_decode($response->getBody()->getContents(), true);

            if ($response->getStatusCode() != 200) {
                $statusCode = $response->getStatusCode();
                $mResponse->message = $resBody;
            } else {
                $mResponse->success = true;
                $mResponse->message = 'success';
                $mResponse->data = $resBody;
            }
        } catch (\Exception $e) {
            $statusCode = 500;
            $mResponse->message = $e->getMessage();
        }

        return response()->json($mResponse, $statusCode);
    }

    public function getByUserID(MSAppGetByUserIdRequest $request)
    {
        $mResponse = new MResponse();
        $statusCode = 200;
        
        $url = 'https://api.mashery.com/v3/rest/members/' . $request->get('userId') . '/applications'; 

        try {
            $response = $this->masheryClient()->request('GET', $url);

            $resBody = json_decode($response->getBody()->getContents(), true);

            if ($response->getStatusCode() != 200) {
                $statusCode = $response->getStatusCode();
                $mResponse->message = $resBody;
            } else {
                $mResponse->success = true;
                $mResponse->message = 'success';
                $mResponse->data = $resBody;
            }
        } catch (\Exception $e) {
            $statusCode = 500;
            $mResponse->message = $e->getMessage();
        }

        return response()->json($mResponse, $statusCode);
    }

    public function getByAppId(MSAppGetByAppIdRequest $request)
    {
        $mResponse = new MResponse();
        $statusCode = 200;
        
        $url = 'https://api.mashery.com/v3/rest/members/' . $request->get('userId') . '/applications/' . $request->get('appId'); 

        try {
            $response = $this->masheryClient()->request('GET', $url);

            $resBody = json_decode($response->getBody()->getContents(), true);

            if ($response->getStatusCode() != 200) {
                $statusCode = $response->getStatusCode();
                $mResponse->message = $resBody;
            } else {
                $mResponse->success = true;
                $mResponse->message = 'success';
                $mResponse->data = $resBody;
            }
        } catch (\Exception $e) {
            $statusCode = 500;
            $mResponse->message = $e->getMessage();
        }

        return response()->json($mResponse, $statusCode);
    }
}
