<?php
/**
 * Created by PhpStorm.
 * User: gets
 * Date: 4/4/2019
 * Time: 4:40 PM
 */

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use GuzzleHttp\Client;


class BaseController extends Controller
{

    protected $request;

    public function __construct(Request $request)
    {
        $this->request = $request;
    }

    protected function masheryClient()
    {
        $client = new Client([
            'base_uri' => 'https://api.mashery.com/',
            'headers' => [
                'Authorization' => $this->request->auth->masheryToken->token_type . ' ' . $this->request->auth->masheryToken->access_token,
                'Content-Type' => 'application/json'
            ],
            'http_errors' => false
        ]);

        return $client;
    }
}
