<?php
/**
 * Created by PhpStorm.
 * User: gets
 * Date: 4/4/2019
 * Time: 1:08 PM
 */

namespace App\Http\Controllers;
use Illuminate\Http\Request;

use App\Classes\MResponse;
use Firebase\JWT\JWT;
use GuzzleHttp\Client;

class MasheryController extends Controller
{

    public function getToken()
    {
        $mResponse = new MResponse();
        $statusCode = 200;

        try {
            $client = new Client([
                'base_uri' => 'https://api.mashery.com/v3/',
                'auth' => ['y4a5rz5ccv374qu33558f65b', 'yuZRnvKvYY'],
                'headers' => [
                    'Authorization' => 'Basic eTRhNXJ6NWNjdjM3NHF1MzM1NThmNjViOnl1WlJudkt2WVk=',
                ],
                'http_errors' => true
            ]);

            $response = $client->request('POST', 'token', [
                'form_params' => [
                    'grant_type' => 'password',
                    'username' => 'marketplace.dev',
                    'password' => 'Marketplace123',
                    'scope' => '71338066-f062-4feb-84b7-6547f0dc4e82'
                ]
            ]);

            $resBody = json_decode($response->getBody()->getContents(), true);

            if ($response->getStatusCode() != 200) {
                $statusCode = $response->getStatusCode();
                $mResponse->message = $resBody;
            } else {
                $mResponse->success = true;
                $mResponse->message = 'success';

                $payload = [
                    'iss' => 'jwt', // Issuer of the token
                    'sub' => (string)$resBody['access_token'],  // Subject of the token
                    'iat' => time(), // Time when JWT was issued.
                    'exp' => time() + env('JWT_EXP_HOUR_TIME'), // Expiration time
                    'masheryToken' => $resBody
                ];

                $mResponse->data = [
                    'token' => JWT::encode($payload, env('JWT_SECRET'))
                ];
            }
            
        } catch (\Exception $e) {
            $statusCode = 500;
            $mResponse->message = $e->getMessage();
        }

        $this->token =  $resBody['access_token'];

        return response()->json($mResponse, $statusCode);
    }
}
