<?php
/**
 * Created by PhpStorm.
 * User: gets
 * Date: 4/4/2019
 * Time: 3:24 PM
 */

namespace App\Http\Controllers;

use App\Classes\MResponse;
use App\Http\Request\MSPackageKeyCreateRequest;
use App\Http\Request\MSPackageKeyActivateRequest;
use App\Http\Request\MSPackageKeyDisableRequest;
use App\Http\Request\MSPackageKeyDeleteRequest;
use App\Http\Request\MSPackageKeyGetByUserRequest;
use App\Http\Request\MSPackageKeyUpdatePlanRequest;

class PackageKeyController extends BaseController
{
    public function create(MSPackageKeyCreateRequest $request)
    {
        $mResponse = new MResponse();
        $statusCode = 200;

        $url = 'https://api.mashery.com/v3/rest/applications/' . $request->get('appId') . '/packageKeys'; 

        try {
            $response = $this->masheryClient()->request('POST', $url, [
                'json' => [
                    'apikey' => '',
                    'secret' => '',
                    'package' => [
                        'id' => $request->get('pkgId')
                    ],
                    'plan' => [
                        'id' => $request->get('planId')
                    ]
                ]
            ]);

            $resBody = json_decode($response->getBody()->getContents(), true);

            if ($response->getStatusCode() != 200) {
                $statusCode = $response->getStatusCode();
                $mResponse->message = $resBody;
            } else {
                $mResponse->success = true;
                $mResponse->message = 'success';
                $mResponse->data = $resBody;
            }
        } catch (\Exception $e) {
            $statusCode = 500;
            $mResponse->message = $e->getMessage();
        }

        return response()->json($mResponse, $statusCode);
    }

    public function activate(MSPackageKeyActivateRequest $request)
    {
        $mResponse = new MResponse();
        $statusCode = 200;
        
        $url = 'https://api.mashery.com/v3/rest/packageKeys/' . $request->get('pkgKeyId'); 

        try {
            $response = $this->masheryClient()->request('PUT', $url, [
                'json' => [
                    'status' => 'active'
                ]
            ]);

            $resBody = json_decode($response->getBody()->getContents(), true);

            if ($response->getStatusCode() != 200) {
                $statusCode = $response->getStatusCode();
                $mResponse->message = $resBody;
            } else {
                $mResponse->success = true;
                $mResponse->message = 'success';
                $mResponse->data = $resBody;
            }
        } catch (\Exception $e) {
            $statusCode = 500;
            $mResponse->message = $e->getMessage();
        }

        return response()->json($mResponse, $statusCode);
    }

    public function disable(MSPackageKeyDisableRequest $request)
    {
        $mResponse = new MResponse();
        $statusCode = 200;
        
        $url = 'https://api.mashery.com/v3/rest/packageKeys/' . $request->get('pkgKeyId'); 

        try {
            $response = $this->masheryClient()->request('PUT', $url, [
                'json' => [
                    'status' => 'disabled'
                ]
            ]);

            $resBody = json_decode($response->getBody()->getContents(), true);

            if ($response->getStatusCode() != 200) {
                $statusCode = $response->getStatusCode();
                $mResponse->message = $resBody;
            } else {
                $mResponse->success = true;
                $mResponse->message = 'success';
                $mResponse->data = $resBody;
            }
        } catch (\Exception $e) {
            $statusCode = 500;
            $mResponse->message = $e->getMessage();
        }

        return response()->json($mResponse, $statusCode);
    }

    public function delete(MSPackageKeyDeleteRequest $request)
    {
        $mResponse = new MResponse();
        $statusCode = 200;
        
        $url = 'https://api.mashery.com/v3/rest/applications/' . $request->get('appId') .'/packageKeys/' . $request->get('pkgKeyId'); 

        try {
            $response = $this->masheryClient()->request('DELETE', $url);

            $resBody = json_decode($response->getBody()->getContents(), true);

            if ($response->getStatusCode() != 200) {
                $statusCode = $response->getStatusCode();
                $mResponse->message = $resBody;
            } else {
                $mResponse->success = true;
                $mResponse->message = 'success';
                $mResponse->data = $resBody;
            }
        } catch (\Exception $e) {
            $statusCode = 500;
            $mResponse->message = $e->getMessage();
        }

        return response()->json($mResponse, $statusCode);
    }

    public function getByUser(MSPackageKeyGetByUserRequest $request)
    {
        $mResponse = new MResponse();
        $statusCode = 200;
        
        $url = 'https://api.mashery.com/v3/rest/members/' . $request->get('userId') . '/packageKeys'; 

        try {
            $response = $this->masheryClient()->request('GET', $url, [
                'query' => [
                    'fields' => 'id,apikey,secret,status,application.id,application.name,application.username,package.id,package.name,plan.id,plan.name'
                ]
            ]);

            $resBody = json_decode($response->getBody()->getContents(), true);

            if ($response->getStatusCode() != 200) {
                $statusCode = $response->getStatusCode();
                $mResponse->message = $resBody;
            } else {
                $mResponse->success = true;
                $mResponse->message = 'success';
                $mResponse->data = $resBody;
            }
        } catch (\Exception $e) {
            $statusCode = 500;
            $mResponse->message = $e->getMessage();
        }

        return response()->json($mResponse, $statusCode);
    }

    public function updatePlan(MSPackageKeyUpdatePlanRequest $request)
    {
        $mResponse = new MResponse();
        $statusCode = 200;
        
        $url = 'https://api.mashery.com/v3/rest/applications/' . $request->get('appId') . '/packageKeys/' . $request->get('pkgKeyId'); 

        try {
            $response = $this->masheryClient()->request('PUT', $url, [
                'json' => [
                    'plan' => [
                        'id' => $request->get('planId')
                    ]
                ]
            ]);

            $resBody = json_decode($response->getBody()->getContents(), true);

            if ($response->getStatusCode() != 200) {
                $statusCode = $response->getStatusCode();
                $mResponse->message = $resBody;
            } else {
                $mResponse->success = true;
                $mResponse->message = 'success';
                $mResponse->data = $resBody;
            }
        } catch (\Exception $e) {
            $statusCode = 500;
            $mResponse->message = $e->getMessage();
        }

        return response()->json($mResponse, $statusCode);
    }
}
