<?php
/**
 * Created by PhpStorm.
 * User: gets
 * Date: 4/4/2019
 * Time: 3:24 PM
 */

namespace App\Http\Controllers;

use App\Classes\MResponse;
use App\Http\Request\MSPackagePlanPlanRequest;

class PackagePlanController extends BaseController
{
    public function getPackagePlan()
    {
        $mResponse = new MResponse();
        $statusCode = 200;

        try {
            $response = $this->masheryClient()->request('GET', 'https://api.mashery.com/v3/rest/packages', [
                'query' => [
                    'fields' => 'id,name,description,plans.id,plans.name,plans.description'
                ]
            ]);

            $resBody = json_decode($response->getBody()->getContents(), true);

            if ($response->getStatusCode() != 200) {
                $statusCode = $response->getStatusCode();
                $mResponse->message = $resBody;
            } else {
                $mResponse->success = true;
                $mResponse->message = 'success';
                $mResponse->data = $resBody;
            }
        } catch (\Exception $e) {
            $statusCode = 500;
            $mResponse->message = $e->getMessage();
        }

        return response()->json($mResponse, $statusCode);
    }

    public function getPackage()
    {
        $mResponse = new MResponse();
        $statusCode = 200;

        try {
            $response = $this->masheryClient()->request('GET', 'https://api.mashery.com/v3/rest/packages', [
                'query' => [
                    'fields' => 'id,name,description'
                ]
            ]);

            $resBody = json_decode($response->getBody()->getContents(), true);

            if ($response->getStatusCode() != 200) {
                $statusCode = $response->getStatusCode();
                $mResponse->message = $resBody;
            } else {
                $mResponse->success = true;
                $mResponse->message = 'success';
                $mResponse->data = $resBody;
            }
        } catch (\Exception $e) {
            $statusCode = 500;
            $mResponse->message = $e->getMessage();
        }

        return response()->json($mResponse, $statusCode);
    }

    public function getPlan(MSPackagePlanPlanRequest $request)
    {
        $mResponse = new MResponse();
        $statusCode = 200;

        $url = 'https://api.mashery.com/v3/rest/packages/' . $request->get('pkgid') . '/plans';

        try {
            $response = $this->masheryClient()->request('GET', $url);

            $resBody = json_decode($response->getBody()->getContents(), true);

            if ($response->getStatusCode() != 200) {
                $statusCode = $response->getStatusCode();
                $mResponse->message = $resBody;
            } else {
                $mResponse->success = true;
                $mResponse->message = 'success';
                $mResponse->data = $resBody;
            }
        } catch (\Exception $e) {
            $statusCode = 500;
            $mResponse->message = $e->getMessage();
        }

        return response()->json($mResponse, $statusCode);
    }
}
