<?php
/**
 * Created by PhpStorm.
 * User: gets
 * Date: 4/4/2019
 * Time: 3:24 PM
 */

namespace App\Http\Controllers;

use App\Classes\MResponse;

class ReportingController extends BaseController
{
    public function callsDevActivityForService(){
        $mResponse = new MResponse();
        $statusCode = 200;

        try {
            $response = $this->masheryClient()->request('GET', 'https://api.mashery.com/v3/rest/reports/calls/developer_activity/service/yn7qb677qd3734sfd8wj2uzy', [
                'query' => [
                    'start_date' => '2019-02-01T00%3A00%3A00Z',
                    'end_date' => '2019-02-07T00%3A00%3A00Z',
                    'format' => 'csv',
                    'limit' => '1000'
                ]
            ]);

            $resBody = json_decode($response->getBody()->getContents(), true);

            if ($response->getStatusCode() != 200) {
                $statusCode = $response->getStatusCode();
                $mResponse->message = $resBody;
            } else {
                $mResponse->success = true;
                $mResponse->message = 'success';
                $mResponse->data = $resBody;
            }
        } catch (\Exception $e) {
            $statusCode = 500;
            $mResponse->message = $e->getMessage();
        }

        return response()->json($mResponse, $statusCode);
    }

    public function callsStatusForService(){
        $mResponse = new MResponse();
        $statusCode = 200;

        try {
            $response = $this->masheryClient()->request('GET', 'https://api.mashery.com/v3/rest/reports/calls/status/service/yn7qb677qd3734sfd8wj2uzy', [
                'query' => [
                    'start_date' => '2019-02-01T00%3A00%3A00Z',
                    'end_date' => '2019-02-07T00%3A00%3A00Z',
                    'format' => 'csv',
                ]
            ]);

            $resBody = json_decode($response->getBody()->getContents(), true);

            if ($response->getStatusCode() != 200) {
                $statusCode = $response->getStatusCode();
                $mResponse->message = $resBody;
            } else {
                $mResponse->success = true;
                $mResponse->message = 'success';
                $mResponse->data = $resBody;
            }
        } catch (\Exception $e) {
            $statusCode = 500;
            $mResponse->message = $e->getMessage();
        }

        return response()->json($mResponse, $statusCode);
    }

    public function callsMethodsForService(){
        $mResponse = new MResponse();
        $statusCode = 200;

        try {
            $response = $this->masheryClient()->request('GET', 'https://api.mashery.com/v3/rest/reports/calls/methods/service/yn7qb677qd3734sfd8wj2uzy', [
                'query' => [
                    'start_date' => '2019-02-01T00%3A00%3A00Z',
                    'end_date' => '2019-02-07T00%3A00%3A00Z',
                    'format' => 'csv',
                    'method_limit' => '5',
                ]
            ]);

            $resBody = json_decode($response->getBody()->getContents(), true);

            if ($response->getStatusCode() != 200) {
                $statusCode = $response->getStatusCode();
                $mResponse->message = $resBody;
            } else {
                $mResponse->success = true;
                $mResponse->message = 'success';
                $mResponse->data = $resBody;
            }
        } catch (\Exception $e) {
            $statusCode = 500;
            $mResponse->message = $e->getMessage();
        }

        return response()->json($mResponse, $statusCode);
    }

    public function callsStatusForServiceForDev(){
        $mResponse = new MResponse();
        $statusCode = 200;

        try {
            $response = $this->masheryClient()->request('GET', 'https://api.mashery.com/v3/rest/reports/calls/status/service/yn7qb677qd3734sfd8wj2uzy/developer/q5qkbdsuza46gyvp5htp8xga', [
                'query' => [
                    'start_date' => '2019-02-01T00%3A00%3A00Z',
                    'end_date' => '2019-02-07T00%3A00%3A00Z',
                    'format' => 'csv'
                ]
            ]);

            $resBody = json_decode($response->getBody()->getContents(), true);

            if ($response->getStatusCode() != 200) {
                $statusCode = $response->getStatusCode();
                $mResponse->message = $resBody;
            } else {
                $mResponse->success = true;
                $mResponse->message = 'success';
                $mResponse->data = $resBody;
            }
        } catch (\Exception $e) {
            $statusCode = 500;
            $mResponse->message = $e->getMessage();
        }

        return response()->json($mResponse, $statusCode);
    }

    public function callsMethodsForServiceForDev(){
        $mResponse = new MResponse();
        $statusCode = 200;

        try {
            $response = $this->masheryClient()->request('GET', 'https://api.mashery.com/v3/rest/reports/calls/methods/service/yn7qb677qd3734sfd8wj2uzy/developer/q5qkbdsuza46gyvp5htp8xga', [
                'query' => [
                    'start_date' => '2019-02-01T00%3A00%3A00Z',
                    'end_date' => '2019-02-07T00%3A00%3A00Z',
                    'format' => 'csv'
                ]
            ]);

            $resBody = json_decode($response->getBody()->getContents(), true);

            if ($response->getStatusCode() != 200) {
                $statusCode = $response->getStatusCode();
                $mResponse->message = $resBody;
            } else {
                $mResponse->success = true;
                $mResponse->message = 'success';
                $mResponse->data = $resBody;
            }
        } catch (\Exception $e) {
            $statusCode = 500;
            $mResponse->message = $e->getMessage();
        }

        return response()->json($mResponse, $statusCode);
    }

    public function callsErrocodesForServiceForDev(){
        $mResponse = new MResponse();
        $statusCode = 200;

        try {
            $response = $this->masheryClient()->request('GET', 'https://api.mashery.com/v3/rest/reports/calls/errorcodes/service/yn7qb677qd3734sfd8wj2uzy/developer/q5qkbdsuza46gyvp5htp8xga', [
                'query' => [
                    'start_date' => '2019-02-01T00%3A00%3A00Z',
                    'end_date' => '2019-02-07T00%3A00%3A00Z',
                    'format' => 'csv',
                    'errorcode_limit' => '5',
                ]
            ]);

            $resBody = json_decode($response->getBody()->getContents(), true);

            if ($response->getStatusCode() != 200) {
                $statusCode = $response->getStatusCode();
                $mResponse->message = $resBody;
            } else {
                $mResponse->success = true;
                $mResponse->message = 'success';
                $mResponse->data = $resBody;
            }
        } catch (\Exception $e) {
            $statusCode = 500;
            $mResponse->message = $e->getMessage();
        }

        return response()->json($mResponse, $statusCode);
    }
}
