<?php
/**
 * Created by PhpStorm.
 * User: gets
 * Date: 4/4/2019
 * Time: 3:24 PM
 */

namespace App\Http\Controllers;

use App\Classes\MResponse;
use App\Http\Request\MSUserCreateRequest;
use App\Http\Request\MSUserGetByUsernameRequest;
use App\Http\Request\MSUserGetByIdRequest;
use App\Http\Request\MSUserUpdateRequest;

class UserController extends BaseController
{
    public function getByUsername(MSUserGetByUsernameRequest $request)
    {
        $mResponse = new MResponse();
        $statusCode = 200;

        try {
            $response = $this->masheryClient()->request('GET', 'https://api.mashery.com/v3/rest/members', [
                'query' => [
                    'filter' => 'username:' . $request->get('username')
                ]
            ]);

            $resBody = json_decode($response->getBody()->getContents(), true);

            if ($response->getStatusCode() != 200) {
                $statusCode = $response->getStatusCode();
                $mResponse->message = $resBody;
            } else {
                $mResponse->success = true;
                $mResponse->message = 'success';
                $mResponse->data = $resBody;
            }
        } catch (\Exception $e) {
            $statusCode = 500;
            $mResponse->message = $e->getMessage();
        }

        return response()->json($mResponse, $statusCode);
    }

    public function getById(MSUserGetByIdRequest $request){
        $mResponse = new MResponse();
        $statusCode = 200;

        $url = 'https://api.mashery.com/v3/rest/members/' . $request->get('userid');

        try {
            $response = $this->masheryClient()->request('GET', $url);

            $resBody = json_decode($response->getBody()->getContents(), true);

            if ($response->getStatusCode() != 200) {
                $statusCode = $response->getStatusCode();
                $mResponse->message = $resBody;
            } else {
                $mResponse->success = true;
                $mResponse->message = 'success';
                $mResponse->data = $resBody;
            }
        } catch (\Exception $e) {
            $statusCode = 500;
            $mResponse->message = $e->getMessage();
        }

        return response()->json($mResponse, $statusCode);
    }

    public function createUser(MSUserCreateRequest $request)
    {
        $mResponse = new MResponse();
        $statusCode = 200;

        try {
            $response = $this->masheryClient()->request('POST', 'https://api.mashery.com/v3/rest/members', [
                'json' => [
                    'username' => $request->get('username'),
                    'email' => $request->get('email'),
                    'displayName' => $request->get('name'),
                    'areaStatus' => 'active',
                    'externalId' => '',
                    'passwdNew' => $request->get('password')
                ]
            ]);

            $resBody = json_decode($response->getBody()->getContents(), true);

            if ($response->getStatusCode() != 200) {
                $statusCode = $response->getStatusCode();
                $mResponse->message = $resBody;
            } else {
                $mResponse->success = true;
                $mResponse->message = 'success';
                $mResponse->data = $resBody;
            }
        } catch (\Exception $e) {
            $statusCode = 500;
            $mResponse->message = $e->getMessage();
        }

        return response()->json($mResponse, $statusCode);
    }

    public function updateUser(MSUserUpdateRequest $request){
        $mResponse = new MResponse();
        $statusCode = 200;

        try {
            $response = $this->masheryClient()->request('GET', 'https://api.mashery.com/v3/rest/members', [
                'query' => [
                    'filter' => 'username:' . $request->get('username')
                ]
            ]);

            $resBody = json_decode($response->getBody()->getContents(), true);

            if ($response->getStatusCode() != 200) {
                $statusCode = $response->getStatusCode();
                $mResponse->message = $resBody;
            } else {
                $mResponse->success = true;
                $mResponse->message = 'success';
                $mResponse->data = $resBody;
            }
        } catch (\Exception $e) {
            $statusCode = 500;
            $mResponse->message = $e->getMessage();
        }

        return response()->json($mResponse, $statusCode);
    }
}
