<?php
/**
 * Created by PhpStorm.
 * User: gets
 * Date: 4/4/2019
 * Time: 3:14 PM
 */

namespace App\Http\Middleware;

use App\Classes\MResponse;
use Closure;
use Firebase\JWT\JWT;
use Firebase\JWT\ExpiredException;

class ClientMiddleware
{

    public function handle($request, Closure $next, $guard = null)
    {
        $token = $request->header('Authorization');
        $response = new MResponse();

        if (empty($token)) {
            $response->message = 'Token not provided';
            return response()->json($response, 401);
        }
        try {
            $credentials = JWT::decode($token, env('JWT_SECRET'), ['HS256']);
        } catch (ExpiredException $e) {
            $response->message = 'Provided token is expired';
            return response()->json($response, 400);
        } catch (Exception $e) {
            $response->message = 'An error while decoding token';
            return response()->json($response, 400);
        }

        $request->auth = $credentials;

        return $next($request);
    }
}
