<?php
/**
 * Created by PhpStorm.
 * User: gets
 * Date: 4/4/2019
 * Time: 4:00 PM
 */
namespace App\Http\Request;

use App\Classes\MResponse;
use Illuminate\Contracts\Validation\Validator;
use Pearl\RequestValidate\RequestAbstract;

class FormRequestErrors extends RequestAbstract
{
    protected function validationData()
    {
        return $this->json()->all();
    }

    /**
     * Format the errors from the given Validator instance.
     *
     * @param  \Illuminate\Contracts\Validation\Validator $validator
     * @return \Illuminate\Http\JsonResponse
     */
    protected function formatErrors(Validator $validator)
    {
        $mResponse = new MResponse();
        $mResponse->message = $validator->errors();
        return response()->json($mResponse, 422);
    }

    protected function getValidatorInstance()
    {
        $this->getInputSource()->replace($this->modifyData());
        $validator = parent::getValidatorInstance();

        return $validator;
    }
}
