<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It is a breeze. Simply tell Lumen the URIs it should respond to
| and give it the Closure to call when that URI is requested.
|
*/

$router->get('/', function () use ($router) {
    return $router->app->version();
});

$router->group(['prefix' => 'mashery'], function () use ($router) {
    //mashery/token
    $router->post('token', 'MasheryController@getToken');
});

$router->group(['middleware' => 'client.auth'], function () use ($router) {
    $router->group(['prefix' => 'user'], function () use ($router) {
        $router->get('by-username', 'UserController@getByUsername');
        $router->get('by-id', 'UserController@getById');
        $router->get('update', 'UserController@updateUser');
        $router->post('create', 'UserController@createUser');
    });

    $router->group(['prefix' => 'application'], function () use ($router) {
        $router->post('create', 'ApplicationController@create');
        $router->put('update', 'ApplicationController@update');
        $router->delete('delete', 'ApplicationController@delete');
        $router->get('by-userid', 'ApplicationController@getByUserId');
        $router->get('by-appid', 'ApplicationController@getByAppId');
    });

    $router->group(['prefix' => 'package'], function () use ($router) {
        $router->get('package', 'PackagePlanController@getPackage');
        $router->get('plan', 'PackagePlanController@getPlan');
        $router->get('package-plan', 'PackagePlanController@getPackagePlan');
    });

    $router->group(['prefix' => 'packageKey'], function () use ($router) {
        $router->post('create', 'PackageKeyController@create');
        $router->put('activate', 'PackageKeyController@activate');
        $router->put('disable', 'PackageKeyController@disable');
        $router->delete('delete', 'PackageKeyController@delete');
        $router->get('get', 'PackageKeyController@getByUser');
        $router->put('update-plan', 'PackageKeyController@updatePlan');
    });

    $router->group(['prefix' => 'report'], function () use ($router) {
        $router->get('devact-serv', 'ReportingController@callsDevActivityForService');
        $router->get('status-serv', 'ReportingController@callsStatusForService');
        $router->get('method-serv', 'ReportingController@callsMethodsForService');
        $router->get('status-serv-dev', 'ReportingController@callsStatusForServiceForDev');
        $router->get('method-serv-dev', 'ReportingController@callsMethodsForServiceForDev');
        $router->get('error-serv-dev', 'ReportingController@callsErrocodesForServiceForDev');
    });
});
